#region References

using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.Common;

#endregion

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgTransfusionReactionCountReportCriteria
	/// </summary>
	public class DlgTransfusionReactionCountReportCriteria : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Controls 

		private System.Windows.Forms.GroupBox grpDivision;
		private System.Windows.Forms.RadioButton rdoCurrentDivision;
		private System.Windows.Forms.RadioButton rdoAllDivisions;
		private System.Windows.Forms.GroupBox grpReportCompilation;
		private System.Windows.Forms.RadioButton rdoScheduleJob;
		private System.Windows.Forms.RadioButton rdoCreateNow;
		private System.Windows.Forms.GroupBox grpScheduleJob;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPrinterName;
		private System.Windows.Forms.Label lblPrinterName;
		private System.Windows.Forms.Label lblPrintDate;
		private System.Windows.Forms.DateTimePicker dtpPrintDate;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox picImage;
		private System.Windows.Forms.GroupBox grpDateRange;
		private System.Windows.Forms.DateTimePicker dtpEndDate;
		private System.Windows.Forms.Label lblEndDate;
		private System.Windows.Forms.Label lblStartDate;
		private System.Windows.Forms.DateTimePicker dtpStartDate;
		private System.Windows.Forms.GroupBox grpReportFormat;
		private System.Windows.Forms.RadioButton rdoDetailedReport;
		private System.Windows.Forms.RadioButton rdoSummaryReport;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Designer generated code

		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgTransfusionReactionCountReportCriteria));
			this.grpDivision = new System.Windows.Forms.GroupBox();
			this.rdoCurrentDivision = new System.Windows.Forms.RadioButton();
			this.rdoAllDivisions = new System.Windows.Forms.RadioButton();
			this.grpReportCompilation = new System.Windows.Forms.GroupBox();
			this.rdoScheduleJob = new System.Windows.Forms.RadioButton();
			this.rdoCreateNow = new System.Windows.Forms.RadioButton();
			this.grpScheduleJob = new System.Windows.Forms.GroupBox();
			this.cmbPrinterName = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblPrinterName = new System.Windows.Forms.Label();
			this.lblPrintDate = new System.Windows.Forms.Label();
			this.dtpPrintDate = new System.Windows.Forms.DateTimePicker();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.picImage = new System.Windows.Forms.PictureBox();
			this.grpDateRange = new System.Windows.Forms.GroupBox();
			this.dtpEndDate = new System.Windows.Forms.DateTimePicker();
			this.lblEndDate = new System.Windows.Forms.Label();
			this.lblStartDate = new System.Windows.Forms.Label();
			this.dtpStartDate = new System.Windows.Forms.DateTimePicker();
			this.grpReportFormat = new System.Windows.Forms.GroupBox();
			this.rdoDetailedReport = new System.Windows.Forms.RadioButton();
			this.rdoSummaryReport = new System.Windows.Forms.RadioButton();
			this.grpDivision.SuspendLayout();
			this.grpReportCompilation.SuspendLayout();
			this.grpScheduleJob.SuspendLayout();
			this.grpImage.SuspendLayout();
			this.grpDateRange.SuspendLayout();
			this.grpReportFormat.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(392, 30);
			this.vbecsLogo1.TabIndex = 6;
			this.vbecsLogo1.Title = "Transfusion Reaction Count Report";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 357);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 8;
			// 
			// grpDivision
			// 
			this.grpDivision.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpDivision.Controls.Add(this.rdoCurrentDivision);
			this.grpDivision.Controls.Add(this.rdoAllDivisions);
			this.grpDivision.Location = new System.Drawing.Point(60, 84);
			this.grpDivision.Name = "grpDivision";
			this.grpDivision.Size = new System.Drawing.Size(328, 64);
			this.grpDivision.TabIndex = 1;
			this.grpDivision.TabStop = false;
			this.grpDivision.Text = "Division*";
			// 
			// rdoCurrentDivision
			// 
			this.rdoCurrentDivision.Checked = true;
			this.rdoCurrentDivision.Location = new System.Drawing.Point(16, 16);
			this.rdoCurrentDivision.Name = "rdoCurrentDivision";
			this.rdoCurrentDivision.Size = new System.Drawing.Size(276, 20);
			this.rdoCurrentDivision.TabIndex = 0;
			this.rdoCurrentDivision.TabStop = true;
			this.rdoCurrentDivision.Text = "Current &Division";
			this.rdoCurrentDivision.CheckedChanged += new System.EventHandler(this.rdoCurrentDivision_CheckedChanged);
			// 
			// rdoAllDivisions
			// 
			this.rdoAllDivisions.Location = new System.Drawing.Point(16, 36);
			this.rdoAllDivisions.Name = "rdoAllDivisions";
			this.rdoAllDivisions.Size = new System.Drawing.Size(276, 20);
			this.rdoAllDivisions.TabIndex = 1;
			this.rdoAllDivisions.Text = "&All Divisions";
			this.rdoAllDivisions.CheckedChanged += new System.EventHandler(this.rdoAllDivisions_CheckedChanged);
			// 
			// grpReportCompilation
			// 
			this.grpReportCompilation.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpReportCompilation.Controls.Add(this.rdoScheduleJob);
			this.grpReportCompilation.Controls.Add(this.rdoCreateNow);
			this.grpReportCompilation.Controls.Add(this.grpScheduleJob);
			this.grpReportCompilation.Location = new System.Drawing.Point(60, 212);
			this.grpReportCompilation.Name = "grpReportCompilation";
			this.grpReportCompilation.Size = new System.Drawing.Size(328, 124);
			this.grpReportCompilation.TabIndex = 3;
			this.grpReportCompilation.TabStop = false;
			this.grpReportCompilation.Text = "Report Compilation*";
			// 
			// rdoScheduleJob
			// 
			this.rdoScheduleJob.Location = new System.Drawing.Point(16, 40);
			this.rdoScheduleJob.Name = "rdoScheduleJob";
			this.rdoScheduleJob.Size = new System.Drawing.Size(120, 16);
			this.rdoScheduleJob.TabIndex = 1;
			this.rdoScheduleJob.Text = "&Schedule Print Job";
			this.rdoScheduleJob.CheckedChanged += new System.EventHandler(this.rdoScheduleJob_CheckedChanged);
			// 
			// rdoCreateNow
			// 
			this.rdoCreateNow.Checked = true;
			this.rdoCreateNow.Location = new System.Drawing.Point(16, 20);
			this.rdoCreateNow.Name = "rdoCreateNow";
			this.rdoCreateNow.Size = new System.Drawing.Size(124, 16);
			this.rdoCreateNow.TabIndex = 0;
			this.rdoCreateNow.TabStop = true;
			this.rdoCreateNow.Text = "Create Report &Now";
			// 
			// grpScheduleJob
			// 
			this.grpScheduleJob.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpScheduleJob.Controls.Add(this.cmbPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrintDate);
			this.grpScheduleJob.Controls.Add(this.dtpPrintDate);
			this.grpScheduleJob.Enabled = false;
			this.grpScheduleJob.Location = new System.Drawing.Point(8, 40);
			this.grpScheduleJob.Name = "grpScheduleJob";
			this.grpScheduleJob.Size = new System.Drawing.Size(312, 76);
			this.grpScheduleJob.TabIndex = 2;
			this.grpScheduleJob.TabStop = false;
			// 
			// cmbPrinterName
			// 
			this.cmbPrinterName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbPrinterName.Interval = 500;
			this.cmbPrinterName.Location = new System.Drawing.Point(96, 44);
			this.cmbPrinterName.Name = "cmbPrinterName";
			this.cmbPrinterName.Size = new System.Drawing.Size(208, 22);
			this.cmbPrinterName.TabIndex = 3;
			this.cmbPrinterName.SelectedIndexChanged += new System.EventHandler(this.cmbPrinterName_SelectedIndexChanged);
			// 
			// lblPrinterName
			// 
			this.lblPrinterName.Location = new System.Drawing.Point(24, 44);
			this.lblPrinterName.Name = "lblPrinterName";
			this.lblPrinterName.Size = new System.Drawing.Size(76, 20);
			this.lblPrinterName.TabIndex = 2;
			this.lblPrinterName.Text = "Printer Name*";
			this.lblPrinterName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblPrintDate
			// 
			this.lblPrintDate.Location = new System.Drawing.Point(24, 20);
			this.lblPrintDate.Name = "lblPrintDate";
			this.lblPrintDate.Size = new System.Drawing.Size(72, 20);
			this.lblPrintDate.TabIndex = 0;
			this.lblPrintDate.Text = "Print Date*";
			this.lblPrintDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpPrintDate
			// 
			this.dtpPrintDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpPrintDate.CalendarFont = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpPrintDate.CustomFormat = "MM/dd/yyyy hh:mm";
			this.dtpPrintDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpPrintDate.Location = new System.Drawing.Point(96, 20);
			this.dtpPrintDate.Name = "dtpPrintDate";
			this.dtpPrintDate.Size = new System.Drawing.Size(208, 20);
			this.dtpPrintDate.TabIndex = 1;
			this.dtpPrintDate.Value = new System.DateTime(2003, 6, 20, 15, 24, 4, 467);
			this.dtpPrintDate.ValueChanged += new System.EventHandler(this.dtpPrintDate_ValueChanged);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(232, 340);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 4;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.CausesValidation = false;
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnCancel.Location = new System.Drawing.Point(312, 340);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 5;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.picImage);
			this.grpImage.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 304);
			this.grpImage.TabIndex = 7;
			this.grpImage.TabStop = false;
			// 
			// picImage
			// 
			this.picImage.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
			this.picImage.Location = new System.Drawing.Point(4, 12);
			this.picImage.Name = "picImage";
			this.picImage.Size = new System.Drawing.Size(45, 45);
			this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picImage.TabIndex = 0;
			this.picImage.TabStop = false;
			// 
			// grpDateRange
			// 
			this.grpDateRange.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpDateRange.Controls.Add(this.dtpEndDate);
			this.grpDateRange.Controls.Add(this.lblEndDate);
			this.grpDateRange.Controls.Add(this.lblStartDate);
			this.grpDateRange.Controls.Add(this.dtpStartDate);
			this.grpDateRange.Enabled = false;
			this.grpDateRange.Location = new System.Drawing.Point(60, 32);
			this.grpDateRange.Name = "grpDateRange";
			this.grpDateRange.Size = new System.Drawing.Size(328, 52);
			this.grpDateRange.TabIndex = 0;
			this.grpDateRange.TabStop = false;
			this.grpDateRange.Text = "Report Date Range";
			// 
			// dtpEndDate
			// 
			this.dtpEndDate.CalendarFont = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpEndDate.CustomFormat = "MM/dd/yyyy";
			this.dtpEndDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpEndDate.Location = new System.Drawing.Point(228, 20);
			this.dtpEndDate.Name = "dtpEndDate";
			this.dtpEndDate.Size = new System.Drawing.Size(88, 20);
			this.dtpEndDate.TabIndex = 3;
			this.dtpEndDate.Value = new System.DateTime(2100, 1, 1, 23, 59, 0, 0);
			this.dtpEndDate.ValueChanged += new System.EventHandler(this.dtpEndDate_ValueChanged);
			// 
			// lblEndDate
			// 
			this.lblEndDate.Location = new System.Drawing.Point(176, 20);
			this.lblEndDate.Name = "lblEndDate";
			this.lblEndDate.Size = new System.Drawing.Size(56, 20);
			this.lblEndDate.TabIndex = 2;
			this.lblEndDate.Text = "End Date*";
			this.lblEndDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblStartDate
			// 
			this.lblStartDate.Location = new System.Drawing.Point(8, 20);
			this.lblStartDate.Name = "lblStartDate";
			this.lblStartDate.Size = new System.Drawing.Size(60, 20);
			this.lblStartDate.TabIndex = 0;
			this.lblStartDate.Text = "Start Date*";
			this.lblStartDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpStartDate
			// 
			this.dtpStartDate.CalendarFont = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpStartDate.CustomFormat = "MM/dd/yyyy";
			this.dtpStartDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpStartDate.Location = new System.Drawing.Point(68, 20);
			this.dtpStartDate.Name = "dtpStartDate";
			this.dtpStartDate.Size = new System.Drawing.Size(88, 20);
			this.dtpStartDate.TabIndex = 1;
			this.dtpStartDate.Value = new System.DateTime(1900, 1, 1, 0, 0, 0, 0);
			this.dtpStartDate.ValueChanged += new System.EventHandler(this.dtpStartDate_ValueChanged);
			// 
			// grpReportFormat
			// 
			this.grpReportFormat.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpReportFormat.Controls.Add(this.rdoDetailedReport);
			this.grpReportFormat.Controls.Add(this.rdoSummaryReport);
			this.grpReportFormat.Location = new System.Drawing.Point(60, 148);
			this.grpReportFormat.Name = "grpReportFormat";
			this.grpReportFormat.Size = new System.Drawing.Size(328, 64);
			this.grpReportFormat.TabIndex = 2;
			this.grpReportFormat.TabStop = false;
			this.grpReportFormat.Text = "Report Format*";
			// 
			// rdoDetailedReport
			// 
			this.rdoDetailedReport.Checked = true;
			this.rdoDetailedReport.Location = new System.Drawing.Point(16, 16);
			this.rdoDetailedReport.Name = "rdoDetailedReport";
			this.rdoDetailedReport.Size = new System.Drawing.Size(276, 20);
			this.rdoDetailedReport.TabIndex = 0;
			this.rdoDetailedReport.TabStop = true;
			this.rdoDetailedReport.Text = "D&etailed Report";
			this.rdoDetailedReport.CheckedChanged += new System.EventHandler(this.rdoDetailedReport_CheckedChanged);
			// 
			// rdoSummaryReport
			// 
			this.rdoSummaryReport.Location = new System.Drawing.Point(16, 36);
			this.rdoSummaryReport.Name = "rdoSummaryReport";
			this.rdoSummaryReport.Size = new System.Drawing.Size(276, 20);
			this.rdoSummaryReport.TabIndex = 1;
			this.rdoSummaryReport.Text = "S&ummary Report";
			this.rdoSummaryReport.CheckedChanged += new System.EventHandler(this.rdoSummaryReport_CheckedChanged);
			// 
			// DlgTransfusionReactionCountReportCriteria
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(392, 373);
			this.Controls.Add(this.grpReportFormat);
			this.Controls.Add(this.grpDivision);
			this.Controls.Add(this.grpReportCompilation);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.grpDateRange);
			this.hlphelpChm.SetHelpKeyword(this, "Transfusion_Reaction_Count_Report.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(400, 400);
			this.Name = "DlgTransfusionReactionCountReportCriteria";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Transfusion Reaction Count Report";
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.grpDateRange, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.grpReportCompilation, 0);
			this.Controls.SetChildIndex(this.grpDivision, 0);
			this.Controls.SetChildIndex(this.grpReportFormat, 0);
			this.grpDivision.ResumeLayout(false);
			this.grpReportCompilation.ResumeLayout(false);
			this.grpScheduleJob.ResumeLayout(false);
			this.grpImage.ResumeLayout(false);
			this.grpDateRange.ResumeLayout(false);
			this.grpReportFormat.ResumeLayout(false);
			this.ResumeLayout(false);

		}

		#endregion

		#region Variables

		private TransfusionReactionReport _transfusionReactionReport;

		#endregion

		#region Properties

		/// <summary>
		/// BloodUnitReport
		/// </summary>
		public TransfusionReactionReport TransfusionReactionReport
		{
			get
			{
				return _transfusionReactionReport;
			}
			set
			{
				_transfusionReactionReport = value;
			} 
		}

		#endregion

		#region Constructors / Destructors

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgTransfusionReactionCountReportCriteria()
		{
			this.TransfusionReactionReport = new TransfusionReactionReport();

			InitializeComponent();

			SetComponentProperties();

			this.btnOK.EnabledButton = true;
			
			//
			// BR_106.03
			this.rdoDetailedReport.Checked = false;
			this.rdoSummaryReport.Checked = true;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Methods

		/// <summary>
		/// SetComponentProperties
		/// </summary>
		private void GetComponentValues()
		{
			if(this.rdoScheduleJob.Checked)
			{	
				this.TransfusionReactionReport.IsScheduled=true;
				this.TransfusionReactionReport.PrintDate=this.dtpPrintDate.Value;
				this.TransfusionReactionReport.PrinterName=this.cmbPrinterName.Text;
			}

			this.TransfusionReactionReport.PrintedBy=Common.LogonUser.LogonUserName;
			this.TransfusionReactionReport.StartDate = dtpStartDate.Value;
			this.TransfusionReactionReport.EndDate = dtpEndDate.Value;
			this.TransfusionReactionReport.DetailedReport = rdoDetailedReport.Checked || !rdoSummaryReport.Checked;
			this.TransfusionReactionReport.IsMultiDivisional = rdoAllDivisions.Checked  || !rdoCurrentDivision.Checked;
		}

		/// <summary>
		/// SetComponentProperties
		/// </summary>
		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC106.DlgTransfusionReactionCountReportCriteria());
			//
			this.btnOK.Text = "&OK";
			this.btnOK.EnabledButton = false;
			//
			this.dtpStartDate.CustomFormat = Common.VBECSDateTime.DateFormat;
			this.dtpEndDate.CustomFormat = Common.VBECSDateTime.DateFormat;
			this.dtpPrintDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;
			//
			this.dtpEndDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime(LogonUser.LogonUserDivisionCode).AddDays(-1);
			this.dtpEndDate.MinDate = this.dtpStartDate.Value;
			//
			this.dtpStartDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime(LogonUser.LogonUserDivisionCode).AddDays(-1);
			this.dtpStartDate.MaxDate = this.dtpEndDate.Value;
			//
			this.dtpPrintDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime(LogonUser.LogonUserDivisionCode);
			this.dtpPrintDate.MinDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime(LogonUser.LogonUserDivisionCode);
			//
			this.grpDateRange.Enabled = true;
			this.dtpStartDate.Enabled = true;
			this.dtpEndDate.Enabled = true;
			//
			this.cmbPrinterName.Items.Clear();
			//
			foreach (string printerName in BOL.VbecsReport.GetPrinters())
			{
				cmbPrinterName.Items.Add(printerName);
			}
		}

		#endregion

		#region Events

		#region Button Clicks

		/// <summary>
		/// SetComponentProperties
		/// </summary>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this.GetComponentValues();
			this.DialogResult = DialogResult.OK;
			this.Close();
		}

		/// <summary>
		/// SetComponentProperties
		/// </summary>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		#endregion

		#region Select Date

		/// <summary>
		/// dtpStartDate_ValueChanged
		/// </summary>
		private void dtpStartDate_ValueChanged(object sender, System.EventArgs e)
		{
			this.TransfusionReactionReport.StartDate = dtpStartDate.Value;
		}

		/// <summary>
		/// dtpEndDate_ValueChanged
		/// </summary>
		private void dtpEndDate_ValueChanged(object sender, System.EventArgs e)
		{
			this.TransfusionReactionReport.EndDate = dtpEndDate.Value;
		}

		#endregion

		#region Select Details

		/// <summary>
		/// SetComponentProperties
		/// </summary>
		private void rdoDetailedReport_CheckedChanged(object sender, System.EventArgs e)
		{
			this.TransfusionReactionReport.DetailedReport = rdoDetailedReport.Checked;
		}

		/// <summary>
		/// SetComponentProperties
		/// </summary>
		private void rdoSummaryReport_CheckedChanged(object sender, System.EventArgs e)
		{
			this.TransfusionReactionReport.DetailedReport = !rdoSummaryReport.Checked;
		}

		#endregion

		#region Select Division

		/// <summary>
		/// SetComponentProperties
		/// </summary>
		private void rdoCurrentDivision_CheckedChanged(object sender, System.EventArgs e)
		{
			this.TransfusionReactionReport.IsMultiDivisional = !rdoCurrentDivision.Checked;
		}

		/// <summary>
		/// SetComponentProperties
		/// </summary>
		private void rdoAllDivisions_CheckedChanged(object sender, System.EventArgs e)
		{
			this.TransfusionReactionReport.IsMultiDivisional = rdoAllDivisions.Checked;
		}

		#endregion

		private void rdoScheduleJob_CheckedChanged(object sender, System.EventArgs e)
		{
			this._transfusionReactionReport.IsScheduled=rdoScheduleJob.Checked;
			this.grpScheduleJob.Enabled=rdoScheduleJob.Checked;
		}

		private void dtpPrintDate_ValueChanged(object sender, System.EventArgs e)
		{
			this._transfusionReactionReport.PrintDate=this.dtpPrintDate.Value;
		}

		private void cmbPrinterName_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(cmbPrinterName.SelectedItem!=null)
			{
				string printer=this.cmbPrinterName.Text;
				for(int i=0; i<this.cmbPrinterName.Items.Count; i++)
				{
					if(printer==this.cmbPrinterName.Items[i].ToString())
					{
						this._transfusionReactionReport.PrinterName = cmbPrinterName.SelectedItem.ToString();
					}
				}
			}		
			else
			{
				this._transfusionReactionReport.PrinterName=String.Empty;
			}
		}

		#endregion
	}
}

